unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OleCtrls, DlsrLib_TLB, StdCtrls, Buttons;

type
  TForm1 = class(TForm)
    SR: TDriverLINXSR;
    cmdOpen: TButton;
    devNum: TComboBox;
    lblStatus: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    cmdReadDI: TButton;
    cmdDOWrite: TButton;
    BitBtn1: TBitBtn;
    DIChannel: TComboBox;
    Label3: TLabel;
    lblDIValue: TLabel;
    bit0: TCheckBox;
    bit1: TCheckBox;
    bit2: TCheckBox;
    bit3: TCheckBox;
    bit4: TCheckBox;
    bit5: TCheckBox;
    bit6: TCheckBox;
    bit7: TCheckBox;
    Label4: TLabel;
    Label5: TLabel;
    procedure cmdOpenClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure cmdReadDIClick(Sender: TObject);
    procedure cmdDOWriteClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.cmdOpenClick(Sender: TObject);
begin
with SR do begin
Req_DLL_name := 'kpciiso$';  // $ means load only the kpciiso driver
Req_device := devNum.ItemIndex;  // since our index equals our values
// don't have to do a string to value conversion of the text
Req_mode := DL_OTHER;
Req_op := DL_INITIALIZE;
Req_subsystem := DL_DEVICE;
Refresh();
end;

If (SR.Res_result = DL_NoErr) Then
     begin
       cmdReadDI.Enabled := True;
       cmdDOWrite.Enabled := True;
       cmdOpen.Enabled := False;
       lblStatus.caption := SR.Message;
     end
Else
begin
lblStatus.caption := SR.Message;
ShowMessage('Verify you have an installed KPCI-PDISO8A');
end;

// set focus back to our dialog
Form1.SetFocus;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
// populate combo box with valid device numbers
devNum.Items.Insert(0,'0');
devNum.Items.Insert(1,'1');
devNum.Items.Insert(2,'2');
devNum.Items.Insert(3,'3');
devNum.Items.Insert(4,'4');
devNum.Items.Insert(5,'5');
// set combo box equal to first entry
devnum.ItemIndex := 0;
// populate channel combo box with legal values
DIChannel.Items.Insert(0,'0');
DIChannel.Items.Insert(1,'1');
// set the channel combo box equal to first entry
DIChannel.ItemIndex := 0;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
// unload the driver
SR.Req_DLL_name := '';  // empty string
end;

procedure TForm1.cmdReadDIClick(Sender: TObject);
var
tempStr : string[4];
begin
with SR do begin
Req_op := DL_START;
Req_subsystem := DL_DI;  // use the DI subsystem
Req_mode := DL_POLLED;
Evt_Tim_type:= DL_NullEvent;   // Polled mode has no timing, start or stop types
Evt_Str_type := DL_NullEvent;
Evt_Stp_type := DL_NullEvent;
Sel_chan_N := 1; // only one channel in the task
Sel_chan_start := DIChannel.ItemIndex;  // KPCI-PDISO8A has two DI channels:
// chan 0 is the isolated inputs; chan 1 is a read back of the output channel
Sel_buf_N := 0;
Sel_chan_format := DL_tNative;
Refresh();    //execute the SR
end;  // with
// single value results stored in SR property
// Res_sta_ioValue...no buffer allocation required
If (SR.Res_result = DL_NoErr) Then
     begin
       str(SR.Res_sta_ioValue, tempStr);
       lblDIValue.Caption := tempStr;  // display the reading....
       lblStatus.caption := SR.Message;
     end
Else
lblStatus.caption := SR.Message;

end;

procedure TForm1.cmdDOWriteClick(Sender: TObject);
var
DOValue : byte;
begin
// get the value to be written from the form's check boxes
DOValue := 0;  // give it initial value
if bit0.Checked then DOValue := 1;
if bit1.Checked then DOValue := DOValue + 2;
if bit2.Checked then DOValue := DOValue + 4;
if bit3.Checked then DOValue := DOValue + 8;
if bit4.Checked then DOValue := DOValue + 16;
if bit5.Checked then DOValue := DOValue + 32;
if bit6.Checked then DOValue := DOValue + 64;
if bit7.Checked then DOValue := DOValue + 128;


with SR do begin
Req_op := DL_START;
Req_subsystem := DL_DO;  // use the DO subsystem
Req_mode := DL_POLLED;
Evt_Tim_type:= DL_NullEvent;
Evt_Str_type := DL_NullEvent;
Evt_Stp_type := DL_NullEvent;
Sel_chan_N := 1;      // only one channel in this task
Sel_chan_start := 1;  // KPCI-PDISO8A has only 1 DO channel
Sel_buf_N := 0;
Sel_chan_format := DL_tNative;
Res_sta_ioValue := DOValue;
Refresh();    //execute the SR
end;  // with
// single value results stored in SR property
// Res_sta_ioValue...no buffer allocation required
If (SR.Res_result = DL_NoErr) Then
     begin
     lblStatus.caption := SR.Message;
     end
     else
     lblStatus.caption := SR.Message;
end;


end.
